/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.schedops.AbstractScheduler;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.schedops.ScheduledOperationsErrorIDs;
import com.ibm.hwmca.fw.schedops.SchedulerException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HMCScheduler
extends AbstractScheduler {
    private static final String CLASS_NAME = "[HMCScheduler] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    private static HMCScheduler INSTANCE;
    private static boolean loaded;
    private static Object loadedLock;

    private HMCScheduler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HMCScheduler getHMCScheduler() {
        Trace.trace(TRACE_MASKT, "[HMCScheduler] >> getHMCScheduler()");
        Object object = loadedLock;
        synchronized (object) {
            if (!loaded) {
                INSTANCE = new HMCScheduler();
                INSTANCE.readAllPersistedScheduledOperations();
                loaded = true;
            }
        }
        Trace.trace(TRACE_MASKT, "[HMCScheduler] << getHMCScheduler()");
        return INSTANCE;
    }

    public void addScheduledOperation(ScheduledOperation schedop) throws SchedulerException {
        Trace.trace(TRACE_MASKT, "[HMCScheduler] >> addScheduledOperation()");
        if (!this.equals(schedop.getOperationTarget().getScheduler())) {
            throw new SchedulerException("Scheduler mismatch");
        }
        super.addScheduledOperation(schedop);
        try {
            schedop.persist();
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, exception);
        }
        Trace.trace(TRACE_MASKT, "[HMCScheduler] << addScheduledOperation()");
    }

    public void removeScheduledOperation(ScheduledOperation schedop) throws SchedulerException {
        Trace.trace(TRACE_MASKT, "[HMCScheduler] >> removeScheduledOperation()");
        super.removeScheduledOperation(schedop);
        try {
            schedop.unpersist();
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, exception);
        }
        Trace.trace(TRACE_MASKT, "[HMCScheduler] << addScheduledOperation()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDisruptiveOperationComplete(ScheduledOperation schedop) throws SchedulerException {
        Trace.trace(TRACE_MASKT, "[HMCScheduler] >> markDisruptiveOperationComplete()");
        AbstractScheduler.SchedulerTask task = null;
        Object object = this.inventoryLock;
        synchronized (object) {
            task = (AbstractScheduler.SchedulerTask)this.inventory.get(schedop);
        }
        if (task == null) {
            throw new SchedulerException("Operation not currently scheduled");
        }
        if (schedop.getLastExecutionDate() != null && !schedop.getLastExecutionStatus()) {
            task.cancel();
            schedop.setLastExecutionStatus(true);
            try {
                schedop.persist();
            }
            catch (Exception exception) {
                Trace.trace(TRACE_MASKF, exception);
            }
        } else {
            throw new SchedulerException("Operation not currently executing");
        }
        Trace.trace(TRACE_MASKT, "[HMCScheduler] << markDisruptiveOperationComplete()");
    }

    protected void expireScheduledOperation(ScheduledOperation schedop) {
        Trace.trace(TRACE_MASKT, "[HMCScheduler] >> expireScheduledOperation()");
        super.expireScheduledOperation(schedop);
        try {
            schedop.unpersist();
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, exception);
        }
        Trace.trace(TRACE_MASKT, "[HMCScheduler] << expireScheduledOperation()");
    }

    private synchronized void readAllPersistedScheduledOperations() {
        Trace.trace(TRACE_MASKT, "[HMCScheduler] >> readAllPersistedScheduledOperations()");
        String namespace = ScheduledOperation.getPersistenceNameSpace();
        PersistenceManager manager = PersistenceManager.getPersistenceManager();
        List names = new ArrayList();
        try {
            names = manager.readChildrenNames(namespace);
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "[HMCScheduler]    Error reading persisted scheduled operations");
            FrameworkLog log = new FrameworkLog(ScheduledOperationsErrorIDs.LOGINFO, 259, exception);
            log.add("Top-level key = " + namespace);
            log.log();
        }
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                ScheduledOperation schedop = (ScheduledOperation)manager.read(key);
                try {
                    super.addScheduledOperation(schedop);
                }
                catch (SchedulerException exception) {
                    Trace.trace(TRACE_MASKF, "[HMCScheduler]    Error adding scheduled operation ... expired ...");
                    this.removeScheduledOperation(schedop);
                }
            }
            catch (Exception exception) {
                Trace.trace(TRACE_MASKF, "[HMCScheduler]    Error reading persisted scheduled operations");
                FrameworkLog log = new FrameworkLog(ScheduledOperationsErrorIDs.LOGINFO, 259, exception);
                log.add("Child key = " + key);
                log.log();
            }
        }
        Trace.trace(TRACE_MASKT, "[HMCScheduler] << readAllPersistedScheduledOperations()");
    }

    private synchronized void persistScheduledOperations() {
        Trace.trace(TRACE_MASKT, "[HMCScheduler] >> persistScheduledOperations()");
        String namespace = ScheduledOperation.getPersistenceNameSpace();
        try {
            List schedops;
            PersistenceManager pm = PersistenceManager.getPersistenceManager();
            if (pm.hasChildren(namespace)) {
                this.removeAllPersistedScheduledOperations();
            }
            if ((schedops = super.getScheduledOperations(HMC.getHMC())).size() > 0) {
                Iterator iterator = schedops.iterator();
                while (iterator.hasNext()) {
                    ScheduledOperation schedop = (ScheduledOperation)iterator.next();
                    pm.writeChild(namespace, schedop);
                }
            }
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "[HMCScheduler]    Error writing persisted scheduled operations");
            new FrameworkLog(ScheduledOperationsErrorIDs.LOGINFO, 259, new HException(exception)).log();
        }
        Trace.trace(TRACE_MASKT, "[HMCScheduler] << persistScheduledOperations()");
    }

    private synchronized void removeAllPersistedScheduledOperations() {
        Trace.trace(TRACE_MASKT, "[HMCScheduler] >> removeAllPersistedScheduledOperations()");
        String namespace = ScheduledOperation.getPersistenceNameSpace();
        PersistenceManager.getPersistenceManager().deleteChildrenRecursive(namespace);
        Trace.trace(TRACE_MASKT, "[HMCScheduler] << removeAllPersistedScheduledOperations()");
    }

    static {
        loaded = false;
        loadedLock = new Object();
    }
}

